IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_PDV_CONSLD_VD_MOVIMENTO]'))
DROP VIEW [dbo].[V_PDV_CONSLD_VD_MOVIMENTO]
GO
--SELECT * FROM V_PDV_CONSLD_VD_MOVIMENTO WHERE CD_EMP =1 AND DT_MOV BETWEEN '2015-12-01' AND '2015-12-15'
CREATE VIEW V_PDV_CONSLD_VD_MOVIMENTO
WITH ENCRYPTION AS
SELECT
	PDV_CONSLD_VD_MOVIMENTO.CD_EMP,
	ISNULL(PRC_REGIAO_FILIAL.NM_REGIAO_FILIAL,'NAO DEFINIDO') AS NM_REGIAO_FILIAL,
	ISNULL(GLB_USU.NM_USU,'NAO DEFINIDO') AS NM_USU,
	PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL,
	PDV_CONSLD_VD_MOVIMENTO.DT_MOV,
	PDV_CONSLD_VD_MOVIMENTO.VLR_LEITUR_Z,
	PDV_CONSLD_VD_MOVIMENTO.VLR_PDV_VD,
	PDV_CONSLD_VD_MOVIMENTO.VLR_PDV_VD_ISSQN,
	PDV_CONSLD_VD_MOVIMENTO.VLR_PDV_VD_IT,
	PDV_CONSLD_VD_MOVIMENTO.VLR_PDV_VD_RCBTO,
	ISNULL(PDV_CONSLD_VD_MOVIMENTO.VLR_DIFERENCA,0) AS VLR_DIFERENCA,	
	CASE WHEN PDV_CONSLD_VD_MOVIMENTO.VLR_LEITUR_Z-(PDV_CONSLD_VD_MOVIMENTO.VLR_PDV_VD-PDV_CONSLD_VD_MOVIMENTO.VLR_PDV_VD_ISSQN)<>0 THEN
		'DIFERENCA ENTRE VALOR LEITURA VERSUS VALOR DA VENDA'
	ELSE
		CASE WHEN PDV_CONSLD_VD_MOVIMENTO.VLR_PDV_VD-PDV_CONSLD_VD_MOVIMENTO.VLR_PDV_VD_IT<>0 THEN
			'DIFERENCA ENTRE VALOR VENDA VERSUS VALOR ITENS DA VENDA'
		ELSE
			CASE WHEN PDV_CONSLD_VD_MOVIMENTO.VLR_PDV_VD-PDV_CONSLD_VD_MOVIMENTO.VLR_PDV_VD_RCBTO<>0 THEN
				'DIFERENCA ENTRE VALOR VENDA VERSUS VALOR DE RECEBIMENTO'
			ELSE
				''
			END		
		END
	END AS DS_TIPO_DIFERENCA,	
	PDV_CONSLD_VD_MOVIMENTO.DT_ULT_CONSD,
	CASE WHEN PDV_CONSLD_VD_MOVIMENTO.FLAG_CAIXA_FECHADO=1 THEN
		'SIM'
	ELSE
		'NAO'
	END CAIXA_FECHADO,
	CASE WHEN PDV_CONSLD_VD_MOVIMENTO.FLAG_CAIXA_BLOQUEADO=1 THEN
		'SIM'
	ELSE
		'NAO'
	END CAIXA_BLOQUEADO,
	CASE WHEN PDV_CONSLD_VD_MOVIMENTO.FLAG_CAIXA_CONSOLIDADO=1 THEN
		'SIM'
	ELSE
		'NAO'
	END CAIXA_CONSOLIDADO,	
	CASE WHEN PDV_CONSLD_VD_MOVIMENTO.FLAG_CARTAO_FECHADO=1 THEN
		'SIM'
	ELSE
		'NAO'
	END CARTAO_FECHADO,
	CASE WHEN PDV_CONSLD_VD_MOVIMENTO.FLAG_EXPORT_CTB=1 THEN
		'SIM'
	ELSE
		'NAO'
	END AS EXPORTACAO_CONTABIL,
	CASE WHEN PDV_CONSLD_VD_MOVIMENTO.FLAG_EXPOT_FISCAL=1 THEN
		'SIM'
	ELSE
		'NAO'
	END AS EXPORTACAO_FISCAL,
	PRC_FILIAL.NM_FANT,
	GLB_CID.DS_CID,
	GLB_CID.UF,
	PRC_FILIAL.CEP
FROM
	PDV_CONSLD_VD_MOVIMENTO LEFT OUTER JOIN PRC_REGIAO_FILIAL_PRC_FILIAL ON
	PDV_CONSLD_VD_MOVIMENTO.CD_EMP = PRC_REGIAO_FILIAL_PRC_FILIAL.CD_EMP AND
	PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL = PRC_REGIAO_FILIAL_PRC_FILIAL.CD_FILIAL 
	LEFT OUTER JOIN PRC_REGIAO_FILIAL ON
	PRC_REGIAO_FILIAL_PRC_FILIAL.CD_EMP = PRC_REGIAO_FILIAL.CD_EMP AND
	PRC_REGIAO_FILIAL_PRC_FILIAL.CD_REGIAO_FILIAL  =  PRC_REGIAO_FILIAL.CD_REGIAO_FILIAL
	LEFT OUTER JOIN GLB_USU ON
	PRC_REGIAO_FILIAL.CD_USU_SUPERVISOR = GLB_USU.CD_USU
	INNER JOIN PRC_FILIAL ON
	PDV_CONSLD_VD_MOVIMENTO.CD_EMP = PRC_FILIAL.CD_EMP AND
	PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL = PRC_FILIAL.CD_FILIAL 
	INNER JOIN GLB_CID ON
	PRC_FILIAL.CD_CID = GLB_CID.CD_CID